require 'chunky_png'
colors = {}

palette = ChunkyPNG::Image.from_file('palette.png')
(0...palette.dimension.width).each do |index|
  colors[palette[index, 0]] = index
end

color_indices = []
image = ChunkyPNG::Image.from_file('image40x25.png')
(0...image.dimension.height).each do |y|
  (0...image.dimension.width).each do |x|
    color_indices << colors[image[x, y]]
  end
end

color_indices.each_slice(30).with_index do |row, index|
  puts "#{1000 + 10 * index} data #{row.join(",")}"
end
